import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';
import {ITrainsStation} from 'types/trains/common/station/ITrainsStation';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {CHAR_NBSP, CHAR_RIGHT_ARROW} from 'utilities/strings/charCodes';
import {getThroughCoachNotificationTimeInfo} from './utilities/getThroughCoachNotificationInfo';

import * as i18nBlock from 'i18n/trains-through-coach-block';

import WarningFilledIcon from 'icons/16/WarningFilled';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';

import cx from './ThroughCoachNotification.scss';

interface IThroughCoachNotificationProps extends IWithClassName {
    arrival: string;
    stationTo: ITrainsStation;
    originalArrival?: string;
    isThroughCoachArrival?: boolean;
}

const ThroughCoachNotification: React.FC<IThroughCoachNotificationProps> =
    props => {
        const {
            className,
            arrival,
            stationTo,
            originalArrival,
            isThroughCoachArrival,
        } = props;

        const throughCoachNotificationTimeInfo = useMemo(() => {
            return getThroughCoachNotificationTimeInfo({
                arrival,
                stationTo,
                originalArrival,
                isThroughCoachArrival,
            });
        }, [arrival, stationTo, originalArrival, isThroughCoachArrival]);

        if (!throughCoachNotificationTimeInfo) {
            return null;
        }

        const {oldDateTime, newDateTime} = throughCoachNotificationTimeInfo;

        return (
            <TextWithIcon
                className={className}
                iconLeft={WarningFilledIcon}
                iconLeftClassName={cx('icon')}
                size="m"
                text={insertJSXIntoKey(i18nBlock.fullTitle)({
                    timeNode: (
                        <span>
                            <span className={cx('oldDate')}>{oldDateTime}</span>
                            {`${CHAR_NBSP}${CHAR_RIGHT_ARROW}${CHAR_NBSP}`}
                            <span>{newDateTime}</span>
                        </span>
                    ),
                })}
            />
        );
    };

export default ThroughCoachNotification;
