import moment from 'moment-timezone';

import {ITrainsStation} from 'types/trains/common/station/ITrainsStation';

import {HUMAN_DATETIME_WITHOUT_YEAR, TIME} from 'utilities/dateUtils/formats';
import isSameISODateString from 'projects/trains/lib/date/isSameISODateString';

interface IThroughCoachNotificationProps {
    arrival: string;
    stationTo: ITrainsStation;
    originalArrival?: string;
    isThroughCoachArrival?: boolean;
}

interface IThroughCoachNotificationInfo {
    oldDateTime: string;
    newDateTime: string;
}

export const getThroughCoachNotificationTimeInfo = (
    props: IThroughCoachNotificationProps,
): IThroughCoachNotificationInfo | null => {
    const {arrival, stationTo, originalArrival, isThroughCoachArrival} = props;

    if (
        !originalArrival ||
        !isThroughCoachArrival ||
        isSameISODateString(arrival, originalArrival)
    ) {
        return null;
    }

    const arrivalMoment = moment.tz(arrival, stationTo.timezone);
    const originalArrivalMoment = moment.tz(
        originalArrival,
        stationTo.timezone,
    );
    const showDate = arrivalMoment.date() !== originalArrivalMoment.date();
    const dateTimeFormat = showDate ? HUMAN_DATETIME_WITHOUT_YEAR : TIME;

    return {
        oldDateTime: originalArrivalMoment.format(dateTimeFormat),
        newDateTime: arrivalMoment.format(dateTimeFormat),
    };
};
