import React from 'react';
import {times} from 'lodash';

import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';

import Box from 'components/Box/Box';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';
import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';

import cx from './PassengersStepSkeleton.scss';

const PassengerBlock: React.FC<IWithDeviceType> = ({
    deviceType: {isDesktop, isMobile},
}) => (
    <BookingLayout.Card>
        <Box between="5">
            <TextSkeleton
                className={cx('passenger-title')}
                withAnimation
                size="xl"
            />

            <Box between={isDesktop ? 9 : 4}>
                <Box between={isDesktop ? 3 : 4}>
                    <Box
                        between={isDesktop ? 2 : 4}
                        inline={isDesktop}
                        nowrap={isDesktop}
                    >
                        {times(3, index => (
                            <Box
                                className={cx(
                                    'field',
                                    index > (isDesktop ? 1 : 0) && 'invisible',
                                )}
                                between="1"
                                key={index}
                            >
                                <TextSkeleton
                                    className={cx('label')}
                                    withAnimation
                                    size="s"
                                />

                                <ButtonSkeleton withAnimation size="l" />

                                {index === 2 && (
                                    <TextSkeleton
                                        className={cx('patronymic-hint')}
                                        withAnimation
                                        size="s"
                                    />
                                )}
                            </Box>
                        ))}
                    </Box>

                    <Box
                        className={cx(isMobile && 'invisible')}
                        between={isDesktop ? 2 : 4}
                        inline={isDesktop}
                        nowrap={isDesktop}
                    >
                        <Box className={cx('field')} between="1">
                            <TextSkeleton
                                className={cx('label')}
                                withAnimation
                                size="s"
                            />

                            <ButtonSkeleton withAnimation size="l" />
                        </Box>

                        <Box
                            className={cx(
                                'field',
                                'field_short',
                                isDesktop && 'invisible',
                            )}
                            between="1"
                        >
                            <TextSkeleton
                                className={cx('label')}
                                withAnimation
                                size="s"
                            />

                            <ButtonSkeleton withAnimation size="l" />

                            <TextSkeleton
                                className={cx('date-hint')}
                                withAnimation
                                size="s"
                            />
                        </Box>
                    </Box>
                </Box>

                <Box
                    className={cx('invisible')}
                    between={isDesktop ? 2 : 4}
                    inline={isDesktop}
                    nowrap={isDesktop}
                >
                    <Box className={cx('field')} between="1">
                        <TextSkeleton
                            className={cx('label')}
                            withAnimation
                            size="s"
                        />

                        <ButtonSkeleton withAnimation size="l" />
                    </Box>

                    <Box className={cx('field')} between="1">
                        <TextSkeleton
                            className={cx('label')}
                            withAnimation
                            size="s"
                        />

                        <ButtonSkeleton withAnimation size="l" />

                        <TextSkeleton
                            className={cx('document-hint')}
                            withAnimation
                            size="s"
                        />
                    </Box>
                </Box>
            </Box>
        </Box>
    </BookingLayout.Card>
);

const ContactsBlock: React.FC<IWithDeviceType> = ({
    deviceType: {isDesktop, isMobile},
}) => (
    <BookingLayout.Card>
        <Box between="5">
            <Box between={isDesktop ? 2 : 0}>
                <TextSkeleton
                    className={cx('contacts-title')}
                    withAnimation
                    size="xl"
                />

                <Box>
                    {times(isDesktop ? 1 : 2, index => (
                        <TextSkeleton
                            className={cx('contacts-subtitle')}
                            size={isDesktop ? 'm' : 's'}
                            key={index}
                            withAnimation
                        />
                    ))}
                </Box>
            </Box>

            <Box
                between={isDesktop ? 2 : 4}
                inline={isDesktop}
                nowrap={isDesktop}
            >
                {times(2, index => (
                    <Box
                        className={cx(
                            'field',
                            isMobile && index === 1 && 'invisible',
                        )}
                        between="1"
                        key={index}
                    >
                        <TextSkeleton
                            className={cx('label')}
                            withAnimation
                            size="s"
                        />

                        <ButtonSkeleton withAnimation size="l" />
                    </Box>
                ))}
            </Box>
        </Box>
    </BookingLayout.Card>
);

const PassengersStepSkeleton: React.FC<IWithDeviceType> = ({deviceType}) => (
    <BookingLayout.Forms className={cx('root', deviceMods('root', deviceType))}>
        <PassengerBlock deviceType={deviceType} />
        <ContactsBlock deviceType={deviceType} />
    </BookingLayout.Forms>
);

export default PassengersStepSkeleton;
