import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';

import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';
import TrainCoachesSkeleton from './components/TrainCoachesSkeleton/TrainCoachesSkeleton';
import PassengersCountSectionSkeleton from './components/PassengersCountSectionSkeleton/PassengersCountSectionSkeleton';

const PlacesStepSkeleton: React.FC<IWithDeviceType> = ({deviceType}) => (
    <BookingLayout.Forms>
        <PassengersCountSectionSkeleton deviceType={deviceType} />
        <TrainCoachesSkeleton deviceType={deviceType} />
    </BookingLayout.Forms>
);

export default PlacesStepSkeleton;
