import {FC} from 'react';

import Box from 'components/Box/Box';
import Skeleton from 'components/Skeletons/Skeleton/Skeleton';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';

import cx from './DesktopTrainCoachesSkeleton.scss';

const DesktopTrainCoachesSkeleton: FC = () => {
    return (
        <BookingLayout.Card className={cx('root')}>
            <TextSkeleton className={cx('title')} size="l" withAnimation />
            <Box inline above={6} between={2}>
                <Skeleton className={cx('tab')} withAnimation />
                <Skeleton className={cx('tab')} withAnimation />
            </Box>
            <Box inline above={6} between={4}>
                <TextSkeleton
                    className={cx('wagonLabel')}
                    size="m"
                    withAnimation
                />
                <TextSkeleton
                    className={cx('wagonLabel')}
                    size="m"
                    withAnimation
                />
            </Box>
        </BookingLayout.Card>
    );
};

export default DesktopTrainCoachesSkeleton;
