import {FC} from 'react';

import Box from 'components/Box/Box';
import Skeleton from 'components/Skeletons/Skeleton/Skeleton';
import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';

import cx from './MobileTrainCoachesSkeleton.scss';

const MobileTrainCoachesSkeleton: FC = () => (
    <BookingLayout.Card className={cx('root')}>
        <TextSkeleton className={cx('title')} size="l" withAnimation />
        <Box inline above={3} between={2}>
            <Skeleton className={cx('tab', 'tab_platzkarte')} withAnimation />
            <Skeleton className={cx('tab', 'tab_compartment')} withAnimation />
        </Box>
        <Box inline above={6} between={4}>
            <Box className={cx('wagon_platzkarte')}>
                <TextSkeleton
                    className={cx('wagon__title')}
                    size="s"
                    withAnimation
                />
                <TextSkeleton
                    className={cx('wagon__hint')}
                    size="s"
                    withAnimation
                />
            </Box>
            <Box className={cx('wagon_compartment')}>
                <TextSkeleton
                    className={cx('wagon__title')}
                    size="s"
                    withAnimation
                />
                <TextSkeleton
                    className={cx('wagon__hint')}
                    size="s"
                    withAnimation
                />
            </Box>
            <Box className={cx('wagon_luxury')}>
                <TextSkeleton
                    className={cx('wagon__title')}
                    size="s"
                    withAnimation
                />
                <TextSkeleton
                    className={cx('wagon__hint')}
                    size="s"
                    withAnimation
                />
            </Box>
        </Box>
        <Box inline above={8} between={3}>
            <TextSkeleton
                className={cx('place__type')}
                size="s"
                withAnimation
            />
            <TextSkeleton
                className={cx('place__price')}
                size="s"
                withAnimation
            />
        </Box>
    </BookingLayout.Card>
);

export default MobileTrainCoachesSkeleton;
