import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';

import Box from 'components/Box/Box';
import Flex from 'components/Flex/Flex';
import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import ButtonSkeleton from 'components/Skeletons/ButtonSkeleton/ButtonSkeleton';

import cx from './PassengersCountSectionSkeleton.scss';

const PassengersCountSectionSkeleton: React.FC<IWithDeviceType> = props => {
    const {deviceType} = props;
    const {isDesktop} = deviceType;

    return (
        <BookingLayout.Card className={cx(deviceMods('root', deviceType))}>
            <TextSkeleton
                className={cx('title')}
                size={isDesktop ? 'xl' : 'l'}
                withAnimation
            />
            <Flex
                above={isDesktop ? 4 : 3}
                justifyContent={isDesktop ? 'flex-start' : 'space-between'}
                alignItems="center"
            >
                <Box>
                    <TextSkeleton
                        className={cx('passengerType')}
                        withAnimation
                    />
                    <TextSkeleton
                        className={cx('passengerHint')}
                        size="s"
                        withAnimation
                    />
                </Box>
                <Flex>
                    <ButtonSkeleton
                        className={cx('minusButton')}
                        size="l"
                        shape="circle"
                        withAnimation
                    />
                    <ButtonSkeleton
                        className={cx('plusButton')}
                        size="l"
                        shape="circle"
                        withAnimation
                    />
                </Flex>
            </Flex>
        </BookingLayout.Card>
    );
};

export default PassengersCountSectionSkeleton;
