import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';

import MobileTrainCoachesSkeleton from '../MobileTrainCoachesSkeleton/MobileTrainCoachesSkeleton';
import DesktopTrainCoachesSkeleton from '../DesktopTrainCoachesSkeleton/DesktopTrainCoachesSkeleton';

interface ITrainCoachesSkeletonProps extends IWithDeviceType {}

const TrainCoachesSkeleton: React.FC<ITrainCoachesSkeletonProps> = props => {
    const {deviceType} = props;
    const {isDesktop} = deviceType;

    if (isDesktop) {
        return <DesktopTrainCoachesSkeleton />;
    }

    return <MobileTrainCoachesSkeleton />;
};

export default TrainCoachesSkeleton;
