import _isEmpty from 'lodash/isEmpty';
import _get from 'lodash/get';
import flat from 'flat';

import {isNotNullable} from 'types/utilities';
import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';
import {ITrainsBookFormValues} from 'types/trains/booking/ITrainsBookFormValues';
import {IFieldError} from 'types/common/validation/form';

import {reachGoal, params} from 'utilities/metrika';

export function reachValidationGoal(
    values: ITrainsBookFormValues,
    errors: object,
): void {
    if (_isEmpty(errors)) {
        return;
    }

    const flattenValues = flat<ITrainsBookFormValues, object>(values);

    Object.keys(flattenValues)
        .filter(isNotNullable)
        .forEach(fieldName => {
            const fieldError: IFieldError | string = _get(errors, fieldName);

            if (fieldError) {
                params({
                    trains: {
                        passengersStep: {
                            submitErrors: fieldName,
                        },
                    },
                });
            }
        });

    reachGoal(ETrainsGoal.ORDER_VALIDATION_ERRORS);
}
