import {EDirection} from 'types/common/EDirection';

import * as i18n from 'i18n/trainsOrderSegments';

export default function getText({
    isRoundTrip,
    direction,
    multipleTrainsInDirection,
}: {
    isRoundTrip: boolean;
    direction: EDirection;
    multipleTrainsInDirection?: boolean;
}): string | null {
    if (isRoundTrip) {
        if (direction === EDirection.FORWARD) {
            return i18n.changeForwardTrain();
        }

        return i18n.changeBackwardTrain();
    }

    if (multipleTrainsInDirection) {
        return i18n.changeTrains();
    }

    return i18n.changeTrain();
}
