import React, {useMemo} from 'react';
import moment from 'moment';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';
import {ITrainSegment} from 'projects/trains/components/TrainsOrderSegments/types';

import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import OrderSegmentMobile from 'projects/trains/components/TrainsOrderSegments/components/OrderSegment/components/OrderSegmentMobile/OrderSegmentMobile';
import OrderSegmentDesktop from 'projects/trains/components/TrainsOrderSegments/components/OrderSegment/components/TrainsOrderSegmentDesktop/OrderSegmentDesktop';

export interface IOrderSegmentProps
    extends IWithClassName,
        IWithDeviceType,
        IWithQaAttributes {
    segment: ITrainSegment;
    showCities: boolean;
    citiesIsLoading?: boolean;
    showETicketBadge?: boolean;
    canVisibleCoachInfo?: boolean;
    canHideCompany?: boolean;
    canVisibleNonRefundableLabel?: boolean;
}

const OrderSegment: React.FC<IOrderSegmentProps> = props => {
    const {deviceType, segment, canHideCompany} = props;

    const duration = useMemo((): number | null => {
        if (!segment) {
            return null;
        }

        return moment(segment.arrival).diff(segment.departure, 's');
    }, [segment]);

    if (segment === null || duration === null) {
        return null;
    }

    if (deviceType.isMobile) {
        return (
            <OrderSegmentMobile
                canHideCompany={canHideCompany}
                duration={duration}
                {...props}
            />
        );
    }

    return <OrderSegmentDesktop duration={duration} {...props} />;
};

export default OrderSegment;
