import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {ITrainCoachInfo} from 'projects/trains/components/TrainsOrderSegments/types';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import getTariffClass from 'projects/trains/lib/getTariffClass';

import * as i18nBlock from 'i18n/account-OrderTrains-Info';

import DotSeparator from 'components/DotSeparator/DotSeparator';
import Text from 'components/Text/Text';
import Intersperse from 'components/Intersperse/Intersperse';

import cx from './OrderSegmentCoachInfo.scss';

interface IOrderSegmentCoachInfoProps
    extends IWithClassName,
        IWithQaAttributes {
    coachInfo: ITrainCoachInfo;
}

const OrderSegmentCoachInfo: React.FC<IOrderSegmentCoachInfoProps> = props => {
    const {
        coachInfo: {type, number, places},
        className,
    } = props;
    const carTitleByType = getTariffClass(type);

    return (
        <div className={className}>
            <Intersperse separator={<DotSeparator />}>
                <Text {...prepareQaAttributes({parent: props, current: 'car'})}>
                    {i18nBlock.car({carNumber: number})}
                </Text>
                {type && (
                    <Text
                        className={cx('carType')}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'carType',
                        })}
                    >
                        {carTitleByType}
                    </Text>
                )}
                {places && Boolean(places.length) && (
                    <Text
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'places',
                        })}
                    >
                        {i18nBlock.places({
                            count: places.length,
                            places: places.join(', '),
                        })}
                    </Text>
                )}
            </Intersperse>
        </div>
    );
};

export default OrderSegmentCoachInfo;
