import React from 'react';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nTrainsOrderConfirmBlock from 'i18n/trains-order-confirm';

import Link from 'components/Link/Link';
import Label, {ECornersType, ELabelThemeType} from 'components/Label/Label';
import cx from 'projects/trains/components/TrainsOrderPage/ConfirmStep/components/Train/Train.scss';

interface IOrderSegmentLabelProps extends IWithQaAttributes {
    eTicketStatus?: boolean;
}

const OrderSegmentETicketInfo: React.FC<IOrderSegmentLabelProps> = props => {
    const {eTicketStatus} = props;

    if (eTicketStatus === undefined) {
        return null;
    }

    if (eTicketStatus) {
        return (
            <Label
                className={cx('label')}
                size="m"
                cornersType={ECornersType.ROUNDED}
                theme={ELabelThemeType.NEUTRAL}
                {...prepareQaAttributes(props)}
            >
                {i18nTrainsOrderConfirmBlock.eDashTicketDashBadge()}
            </Label>
        );
    }

    return (
        <Link
            className={cx('link')}
            url="https://yandex.ru/support/travel/trains/e-registration.html"
            target="_blank"
            rel="nofollow noopener noreferrer"
        >
            {i18nTrainsOrderConfirmBlock.withoutDashErDashHelpDashLink()}
        </Link>
    );
};

export default OrderSegmentETicketInfo;
