import React from 'react';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import Flex from 'components/Flex/Flex';
import TrainsSegmentTitleMobile from 'projects/trains/components/TrainSegment/TrainsSegmentTitleMobile/TrainsSegmentTitleMobile';
import OrderSegmentTimeAndStations from 'projects/trains/components/TrainsOrderSegments/components/OrderSegment/components/OrderSegmentTimeAndStations/OrderSegmentTimeAndStations';
import OrderSegmentETicketInfo from 'projects/trains/components/TrainsOrderSegments/components/OrderSegment/components/OrderSegmentETicketInfo/OrderSegmentETicketInfo';
import {IOrderSegmentProps} from 'projects/trains/components/TrainsOrderSegments/components/OrderSegment/OrderSegment';
import ThroughCoachNotification from 'projects/trains/components/TrainsOrderPage/ThroughCoachNotification/ThroughCoachNotification';

import OrderSegmentCoachInfo from '../OrderSegmentCoachInfo/OrderSegmentCoachInfo';
import OrderSegmentNonRefundableLabel from '../OrderSegmentNonRefundableLabel/OrderSegmentNonRefundableLabel';

import cx from './OrderSegmentMobile.scss';

interface IOrderSegmentMobileProps extends IOrderSegmentProps {
    duration: number;
}

const OrderSegmentMobile: React.FC<IOrderSegmentMobileProps> = props => {
    const {
        className,
        segment,
        duration,
        deviceType,
        showCities,
        citiesIsLoading,
        showETicketBadge,
        canHideCompany,
        canVisibleCoachInfo,
        canVisibleNonRefundableLabel,
    } = props;
    const {
        arrival,
        coachInfo,
        stationTo,
        originalArrival,
        isThroughCoachArrival,
        hasNonRefundableTariff,
    } = segment;

    return (
        <div className={cx('root', className)} {...prepareQaAttributes(props)}>
            <TrainsSegmentTitleMobile
                className={cx('title')}
                segment={segment}
                features={segment.features}
                deviceType={deviceType}
                canHideCompany={canHideCompany}
                {...prepareQaAttributes(props)}
            />
            {canVisibleCoachInfo && coachInfo && (
                <OrderSegmentCoachInfo
                    className={cx('coachInfo')}
                    coachInfo={coachInfo}
                    {...prepareQaAttributes(props)}
                />
            )}
            <OrderSegmentTimeAndStations
                className={cx('timeAndStations')}
                segment={segment}
                duration={duration}
                deviceType={deviceType}
                showCities={showCities}
                citiesIsLoading={citiesIsLoading}
                {...prepareQaAttributes(props)}
            />
            <ThroughCoachNotification
                className={cx('throughCoachNotification')}
                arrival={arrival}
                stationTo={stationTo}
                originalArrival={originalArrival}
                isThroughCoachArrival={isThroughCoachArrival}
            />
            <Flex
                flexDirection="column"
                alignItems="flex-start"
                above={3}
                between={1}
            >
                {canVisibleNonRefundableLabel && hasNonRefundableTariff && (
                    <OrderSegmentNonRefundableLabel />
                )}
                {showETicketBadge && (
                    <OrderSegmentETicketInfo
                        eTicketStatus={segment.eTicketStatus}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'electronicRegistration',
                        })}
                    />
                )}
            </Flex>
        </div>
    );
};

export default OrderSegmentMobile;
