import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/account-OrderTrains-Info';

import Label, {ECornersType, ELabelThemeType} from 'components/Label/Label';

interface IOrderSegmentNonRefundableLabelProps
    extends IWithQaAttributes,
        IWithClassName {}

const OrderSegmentNonRefundableLabel: React.FC<IOrderSegmentNonRefundableLabelProps> =
    props => {
        const {className} = props;

        return (
            <Label
                className={className}
                size="m"
                theme={ELabelThemeType.ATTENTION}
                cornersType={ECornersType.ROUNDED}
                {...prepareQaAttributes(props)}
            >
                {i18nBlock.nonRefundableLabel()}
            </Label>
        );
    };

export default OrderSegmentNonRefundableLabel;
