import React from 'react';

import {ITrainSegment} from 'projects/trains/components/TrainsOrderSegments/types';
import {IWithDeviceType} from 'types/withDeviceType';
import {IWithClassName} from 'types/withClassName';

import {
    prepareQaAttributes,
    IWithQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import OrderSegmentStations from 'projects/trains/components/TrainsOrderSegments/components/OrderSegment/components/OrderSegmentTimeAndStations/components/OrderSegmentStations/OrderSegmentStations';
import OrderSegmentTimeAndDuration from 'projects/trains/components/TrainsOrderSegments/components/OrderSegment/components/OrderSegmentTimeAndStations/components/OrderSegmentTimeAndDuration/OrderSegmentTimeAndDuration';

import cx from './OrderSegmentTimeAndStations.scss';

interface IOrderSegmentTimeAndStationsProps
    extends IWithDeviceType,
        IWithQaAttributes,
        IWithClassName {
    segment: ITrainSegment;
    duration: number;
    showCities: boolean;
    citiesIsLoading?: boolean;
}

const OrderSegmentTimeAndStations: React.FC<IOrderSegmentTimeAndStationsProps> =
    props => {
        const {
            className,
            segment,
            deviceType,
            duration,
            showCities,
            citiesIsLoading,
        } = props;

        return (
            <div className={cx('root', className)}>
                <OrderSegmentTimeAndDuration
                    segment={segment}
                    duration={duration}
                    deviceType={deviceType}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'timeAndDuration',
                    })}
                />

                <OrderSegmentStations
                    segment={segment}
                    deviceType={deviceType}
                    showCities={showCities}
                    citiesIsLoading={citiesIsLoading}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'stations',
                    })}
                />
            </div>
        );
    };

export default OrderSegmentTimeAndStations;
