import React from 'react';

import {ITrainSegment} from 'projects/trains/components/TrainsOrderSegments/types';
import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Station from 'projects/trains/components/TrainSegment/Station/Station';

import cx from './OrderSegmentStations.scss';

interface IOrderSegmentStationsProps
    extends IWithDeviceType,
        IWithQaAttributes {
    segment: ITrainSegment;
    showCities: boolean;
    citiesIsLoading?: boolean;
}

const OrderSegmentStations: React.FC<IOrderSegmentStationsProps> = props => {
    const {segment, showCities, deviceType, citiesIsLoading} = props;

    const cityFrom = segment.stationFrom.settlement?.title;
    const cityTo = segment.stationTo.settlement?.title;
    const citiesIsEqual = cityFrom && cityTo && cityFrom === cityTo;

    return (
        <div className={cx('root', deviceMods('root', deviceType))}>
            <Station
                align="left"
                station={
                    segment.stationFrom.popularTitle ||
                    segment.stationFrom.title
                }
                cityIsVisible={!citiesIsEqual && showCities}
                cityIsLoading={citiesIsLoading}
                city={cityFrom}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'departure',
                })}
            />

            <Station
                align="right"
                station={
                    segment.stationTo.popularTitle || segment.stationTo.title
                }
                cityIsVisible={!citiesIsEqual && showCities}
                cityIsLoading={citiesIsLoading}
                city={cityTo}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'arrival',
                })}
            />
        </div>
    );
};

export default OrderSegmentStations;
