import {IWithClassName} from 'types/withClassName';
import {EDirection} from 'types/common/EDirection';

import {IOrderTripInfo} from 'selectors/trains/order/orderTripInfoSelector';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Flex from 'components/Flex/Flex';
import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';
import OrderSegmentsTitle from 'projects/trains/components/TrainsOrderSegments/components/OrderSegmentsTitle/OrderSegmentsTitle';

import cx from './OrderSegmentsHeader.scss';

interface IOrderSegmentsHeaderProps extends IWithClassName, IWithQaAttributes {
    tripInfo: IOrderTripInfo;
    direction: EDirection;
}

const OrderSegmentsHeader: React.FC<IOrderSegmentsHeaderProps> = props => {
    const {tripInfo, direction} = props;
    const deviceType = useDeviceType();

    return (
        <BookingLayout.Card.Section paddingBottom={deviceType.isMobile ? 4 : 5}>
            <Flex
                className={cx('headerContent')}
                alignItems="flex-start"
                justifyContent="space-between"
            >
                <OrderSegmentsTitle
                    tripInfo={tripInfo}
                    deviceType={deviceType}
                    direction={direction}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'title',
                    })}
                />
            </Flex>
        </BookingLayout.Card.Section>
    );
};

export default OrderSegmentsHeader;
