import {EDirection} from 'types/common/EDirection';
import {ITrainFeature} from 'projects/trains/lib/segments/features/types';
import {ITrainsStation} from 'types/trains/common/station/ITrainsStation';
import {ETrainsCoachType} from 'types/trains/common/tariffs/ETrainsCoachType';

export interface ITrainCoachInfo {
    number: string;
    type: ETrainsCoachType;
    places?: string[];
}

export interface ITrainSegment {
    arrival: string;
    departure: string;
    stationFrom: ITrainsStation;
    stationTo: ITrainsStation;
    number: string;
    title: string;
    eTicketStatus?: boolean;
    features: ITrainFeature[];
    coachInfo?: ITrainCoachInfo;
    originalArrival?: string;
    isThroughCoachArrival?: boolean;
    hasNonRefundableTariff?: boolean;
}

export type TAllSegments = Record<
    EDirection,
    Record<number, ITrainSegment | null>
>;
