import {IDevice} from 'reducers/common/commonReducerTypes';

import {TBoxSizes} from 'components/Box/Box';

interface ISegmentPaddings {
    paddingTop: TBoxSizes;
    paddingBottom: TBoxSizes;
}

/**
 * Возвращает отступы в сегментах
 * @param deviceType несколько поездов в направлении
 * @param multipleTrains в направлении несколько поездов
 * @param isRoundTrip поезда туда-обратно
 */
export default function getSegmentPaddings(
    deviceType: IDevice,
    multipleTrains: boolean,
    isRoundTrip: boolean,
): ISegmentPaddings {
    if (isRoundTrip) {
        return {
            paddingTop: 4,
            paddingBottom: deviceType.isMobile ? 4 : 8,
        };
    }

    if (!multipleTrains) {
        return {
            paddingTop: deviceType.isMobile ? 4 : 0,
            paddingBottom: deviceType.isMobile ? 5 : 8,
        };
    }

    return {
        paddingTop: deviceType.isMobile ? 4 : 3,
        paddingBottom: deviceType.isMobile ? 4 : 5,
    };
}
