import React from 'react';

import getTrainsPageCrumb from 'projects/trains/lib/meta/searchMeta/semanticData/getTrainsPageCrumb';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import * as trainsPopularRoutesKeyset from 'i18n/trains-popular-routes';

import TrainsBreadcrumbs from 'projects/trains/components/TrainsBreadcrumbs';

import cx from './styles.scss';

interface ITrainsPopularRoutesBreadcrumbsProps {}

const TrainsPopularRoutesBreadcrumbs: React.FC<ITrainsPopularRoutesBreadcrumbsProps> =
    () => {
        const trainsPageCrumb = getTrainsPageCrumb();

        return (
            <TrainsBreadcrumbs className={cx('root')}>
                <TrainsBreadcrumbs.Item
                    to={trainsPageCrumb.url}
                    title={trainsPageCrumb.title}
                    {...prepareQaAttributes({
                        key: '0',
                        current: 'trainsBreadcrumbsItem',
                    })}
                >
                    {trainsPageCrumb.name}
                </TrainsBreadcrumbs.Item>

                <TrainsBreadcrumbs.Item
                    title={trainsPopularRoutesKeyset.crumbDashTitle()}
                    {...prepareQaAttributes({
                        key: '1',
                        current: 'trainsBreadcrumbsItem',
                    })}
                >
                    {trainsPopularRoutesKeyset.crumbDashName()}
                </TrainsBreadcrumbs.Item>
            </TrainsBreadcrumbs>
        );
    };

export default TrainsPopularRoutesBreadcrumbs;
