import React, {Component} from 'react';

import {TTrainPopularRoutes} from 'types/trains/common/popularRoutes/popularRoutes';

import {IDevice} from 'reducers/common/commonReducerTypes';

import {deviceMods} from 'utilities/stylesUtils';

import Select from 'components/Select/Select';
import TrainsPopularRoutesTabsItem from 'projects/trains/components/TrainsPopularRoutesPage/TrainsPopularRoutesTabsItem';

import cx from './styles.scss';

interface ITrainsPopularRoutesTabsProps {
    popularRoutes: TTrainPopularRoutes;
    activeTab: string;
    deviceType: IDevice;
    onChange: (code: string) => void;
}

export default class TrainsPopularRoutesTabs extends Component<ITrainsPopularRoutesTabsProps> {
    private renderSelect(): React.ReactNode {
        const {popularRoutes, activeTab, onChange} = this.props;

        const options = popularRoutes.map(item => ({
            value: item.code,
            data: item.title,
        }));

        return (
            <div className={cx('select')}>
                <Select
                    width="max"
                    value={activeTab}
                    options={options}
                    onChange={onChange}
                />
            </div>
        );
    }

    private renderTabs(): React.ReactNode {
        const {popularRoutes, activeTab, onChange} = this.props;

        return (
            <div className={cx('tabs')}>
                {popularRoutes.map(item => (
                    <TrainsPopularRoutesTabsItem
                        key={item.code}
                        code={item.code}
                        title={item.title}
                        isActive={item.code === activeTab}
                        onClick={onChange}
                    />
                ))}
            </div>
        );
    }

    render(): React.ReactNode {
        const {deviceType} = this.props;

        return (
            <div className={cx('root', deviceMods('root', deviceType))}>
                {deviceType.isDesktop && this.renderTabs()}

                {this.renderSelect()}
            </div>
        );
    }
}
