import React, {useCallback} from 'react';

import cx from './styles.scss';

interface ITrainsPopularRoutesTabsItemProps {
    code: string;
    title: string;
    isActive: boolean;
    onClick: (code: string) => void;
}

const TrainsPopularRoutesTabsItem: React.FC<ITrainsPopularRoutesTabsItemProps> =
    props => {
        const {code, title, isActive, onClick} = props;

        const handleClick = useCallback(() => {
            onClick(code);
        }, [code, onClick]);

        return (
            <button
                className={cx('root', {root_isActive: isActive})}
                type="button"
                onClick={handleClick}
            >
                {title}
            </button>
        );
    };

export default TrainsPopularRoutesTabsItem;
