import {ORDER_STEP} from 'projects/trains/constants/orderSteps';

import {TTrainsOrderStep} from 'types/trains/common/steps/ITrainsSearchAndOrderSteps';
import {EDirection} from 'types/common/EDirection';

import * as i18nBlock from 'i18n/trains-SearchAndOrderSteps';

export default function getTrainsOrderStepText({
    step,
    isRoundTrip,
}: {
    step: TTrainsOrderStep;
    isRoundTrip: boolean;
}): string {
    switch (step.type) {
        case ORDER_STEP.PLACES: {
            const stepPlacesText = i18nBlock.orderPlaces();
            const {segmentCount, segmentIndex, direction} = step;

            if (isRoundTrip) {
                if (direction === EDirection.BACKWARD) {
                    return i18nBlock.orderBackwardDirectionPlaces();
                }

                return i18nBlock.orderForwardDirectionPlaces();
            }

            if (segmentCount < 2) {
                return stepPlacesText;
            }

            if (segmentCount < 3) {
                const trainNumberText =
                    segmentIndex === 0
                        ? i18nBlock.orderFirstTrain()
                        : i18nBlock.orderSecondTrain();

                return `${stepPlacesText}. ${trainNumberText}`;
            }

            return `${stepPlacesText} ${i18nBlock.orderTrainNumber({
                number: segmentIndex + 1,
            })}`;
        }
        case ORDER_STEP.PASSENGERS:
            return i18nBlock.orderPassengers();
        case ORDER_STEP.CONFIRM:
            return i18nBlock.orderConfirm();
        case ORDER_STEP.PAYMENT:
            return i18nBlock.orderPayment();
    }
}
