import {
    ETrainsSearchStepType,
    TTrainsSearchStep,
} from 'types/trains/common/steps/ITrainsSearchAndOrderSteps';

import * as i18nBlock from 'i18n/trains-SearchAndOrderSteps';

export default function getTrainsSearchStepText({
    step,
}: {
    step: TTrainsSearchStep;
}): string {
    switch (step.type) {
        case ETrainsSearchStepType.ONE_WAY_FORWARD: {
            return i18nBlock.searchOneWay();
        }
        case ETrainsSearchStepType.ROUND_TRIP_FORWARD:
            return i18nBlock.searchForwardDirection();
        case ETrainsSearchStepType.ROUND_TRIP_BACKWARD:
            return i18nBlock.searchBackwardDirection();
    }
}
