import {EDirection} from 'types/common/EDirection';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {
    ETrainsSearchStepType,
    TTrainsSearchStep,
} from 'types/trains/common/steps/ITrainsSearchAndOrderSteps';

import {trainsURLs} from 'projects/trains/lib/urls';
import {prepareTrainsContextForSearchUrl} from 'projects/trains/lib/urls/getTrainsSearchUrl';

export default function getTrainsSearchStepUrl({
    step,
    context,
}: {
    step: TTrainsSearchStep;
    context: ITrainsFilledSearchContext;
}): string {
    const isBackwardDirection =
        step.type === ETrainsSearchStepType.ROUND_TRIP_BACKWARD;

    return trainsURLs.getTrainsSearchUrl({
        context: prepareTrainsContextForSearchUrl(context),
        forwardSegmentId: context.forwardSegmentId,
        direction: isBackwardDirection
            ? EDirection.BACKWARD
            : EDirection.FORWARD,
    });
}
