import {FC, memo, useCallback} from 'react';
import {useSelector} from 'react-redux';

import {EYtpReferer} from 'types/common/IAttribution';
import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';

import {requestParamsSelector} from 'projects/trains/components/TrainsSearchVariants/components/HotelsCrossSaleMap/selectors/requestParamsSelector';

import {reachGoal} from 'utilities/metrika';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import SearchHotelsCrossSaleMap from 'components/SearchHotelsCrossSaleMap/SearchHotelsCrossSaleMap';

interface IHotelsCrossSaleMap extends IWithQaAttributes {}

const HotelsCrossSaleMap: FC<IHotelsCrossSaleMap> = props => {
    const requestParams = useSelector(requestParamsSelector);

    const onCrossSaleShow = useCallback(() => {
        reachGoal(ETrainsGoal.SEARCH_CROSS_SALE_HOTELS_MAP_LOAD);
    }, []);

    const onCrossSaleClick = useCallback(() => {
        reachGoal(ETrainsGoal.SEARCH_CROSS_SALE_HOTELS_MAP_CLICK);
    }, []);

    if (!requestParams) {
        return null;
    }

    return (
        <SearchHotelsCrossSaleMap
            requestParams={requestParams}
            ytpReferer={EYtpReferer.TRAINS_SEARCH_MAP}
            onCrossSaleShow={onCrossSaleShow}
            onCrossSaleClick={onCrossSaleClick}
            {...prepareQaAttributes(props)}
        />
    );
};

export default memo(HotelsCrossSaleMap);
