import {createSelector} from 'reselect';

import {isFilledTrainsSearchContext} from 'reducers/trains/context/types';

import {trainsContextSelector} from 'selectors/trains/trainsContextSelector';
import {crossSaleHotelsLimitSelector} from 'selectors/common/hotelsCrossSale/crossSaleHotelsLimitSelector';

import {ICrossSaleRequestParams} from 'components/SearchHotelsCrossSaleMap/SearchHotelsCrossSaleMap';

export const requestParamsSelector = createSelector(
    trainsContextSelector,
    crossSaleHotelsLimitSelector,
    (context, totalHotelLimit): ICrossSaleRequestParams | null => {
        if (!isFilledTrainsSearchContext(context)) {
            return null;
        }

        return {
            pointKey: context.to.key,
            totalHotelLimit,
            checkinDate: context.when,
            checkoutDate: context.returnWhen ?? undefined,
        };
    },
);
