import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {getTrainRangeArrivalByFeatures} from 'projects/trains/lib/genericSearch/train/getTrainRangeArrivalByFeatures';
import {getTrainsSegmentTariffViewType} from 'projects/trains/components/TrainsSearchVariants/components/TrainsSearchSegment/utilities/getTrainsSegmentTariffViewType';

import Box from 'components/Box/Box';
import TrainsSegmentPoints from '../components/TrainsSegmentPoints/TrainsSegmentPoints';
import TrainsSegmentLayout from '../components/TrainsSegmentLayout/TrainsSegmentLayout';
import TrainsSegmentDuration from '../components/TrainsSegmentDuration/TrainsSegmentDuration';
import TrainsSegmentInfo from '../components/TrainsSegmentInfo/TrainsSegmentInfo';
import TrainsSegmentTariffs from '../components/TrainsSegmentTariffs/TrainsSegmentTariffs';

import TrainsSearchVariantPriceAndAction from '../../TrainsSearchVariantPriceAndAction/TrainsSearchVariantPriceAndAction';
import {ITrainsSearchSegmentProps} from '../TrainsSearchSegment';

import cx from './TrainsDesktopSearchSegment.scss';

const TrainsDesktopSearchSegment: React.FC<ITrainsSearchSegmentProps> =
    props => {
        const {
            segment,
            variant,
            className,
            context,
            direction,
            searchStatus,
            canHidePrice,
            isPinnedSegment,
            isTransferSegment,
            canVisibleSegmentAction = true,
        } = props;
        const deviceType = useDeviceType();
        const trainRangeArrival = getTrainRangeArrivalByFeatures(
            segment.features,
        );
        const isRangeArrivalTrain = Boolean(trainRangeArrival);
        const tariffViewType = getTrainsSegmentTariffViewType({
            context,
            isTransferSegment,
        });

        return (
            <TrainsSegmentLayout
                className={cx(className, 'root')}
                centerClassName={cx('centerColumn')}
                rightClassName={
                    canVisibleSegmentAction ? cx('rightColumn') : ''
                }
                left={
                    <>
                        <TrainsSegmentPoints
                            stationTo={segment.stationTo}
                            stationFrom={segment.stationFrom}
                            arrival={segment.arrival}
                            departure={segment.departure}
                            deviceType={deviceType}
                            trainRangeArrival={trainRangeArrival}
                            {...prepareQaAttributes(props)}
                        />
                        <Box className={cx('info')} between="1">
                            <TrainsSegmentDuration
                                duration={segment.duration}
                                isRangeArrivalTrain={isRangeArrivalTrain}
                                deviceType={deviceType}
                                {...prepareQaAttributes({
                                    parent: props,
                                    current: 'duration',
                                })}
                            />
                            <TrainsSegmentInfo
                                segment={segment}
                                deviceType={deviceType}
                                size="m"
                                {...prepareQaAttributes(props)}
                            />
                        </Box>
                    </>
                }
                center={
                    <TrainsSegmentTariffs
                        tariffs={segment.tariffs}
                        train={segment.train}
                        features={segment.features}
                        variant={variant}
                        context={context}
                        deviceType={deviceType}
                        tariffViewType={tariffViewType}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'tariffs',
                        })}
                    />
                }
                right={
                    canVisibleSegmentAction ? (
                        <TrainsSearchVariantPriceAndAction
                            context={context}
                            variant={variant}
                            direction={direction}
                            canHidePrice={canHidePrice}
                            searchStatus={searchStatus}
                            deviceType={deviceType}
                            isPinnedSegment={isPinnedSegment}
                            {...prepareQaAttributes(props)}
                        />
                    ) : null
                }
                {...prepareQaAttributes(props)}
            />
        );
    };

export default TrainsDesktopSearchSegment;
