import React, {memo} from 'react';

import {EDirection} from 'types/common/EDirection';
import {ITrainsSegment} from 'types/trains/common/segment/ITrainsSegment';
import {IWithClassName} from 'types/withClassName';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {EQueryingStatus} from 'types/trains/search/searchInfo/ITrainsSearchInfo';
import {ITrainsVariant} from 'types/trains/common/variant/ITrainsVariant';
import {ISearchSegmentBadge} from 'components/SearchSegmentBadges/types/ISearchSegmentBadge';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import TrainsDesktopSearchSegment from './TrainsDesktopSearchSegment/TrainsDesktopSearchSegment';
import TrainsMobileSearchSegment from './TrainsMobileSearchSegment/TrainsMobileSearchSegment';

export interface ITrainsSearchSegmentProps
    extends IWithClassName,
        IWithQaAttributes {
    segment: ITrainsSegment;
    variant: ITrainsVariant;
    direction: EDirection;
    context: ITrainsFilledSearchContext;
    searchStatus: EQueryingStatus;
    canHidePrice?: boolean;
    isPinnedSegment?: boolean;
    isTransferSegment?: boolean;
    canVisibleSegmentAction?: boolean;
    variantBadges?: ISearchSegmentBadge[];
}

const TrainsSearchSegment: React.FC<ITrainsSearchSegmentProps> = props => {
    const {isDesktop} = useDeviceType();

    if (isDesktop) {
        return <TrainsDesktopSearchSegment {...props} />;
    }

    return <TrainsMobileSearchSegment {...props} />;
};

export default memo(TrainsSearchSegment);
