import React from 'react';
import moment from 'moment-timezone';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import humanizeDuration from 'projects/trains/lib/date/duration/humanizeDuration';

import * as i18nBlock from 'i18n/trains-time';

import Text from 'components/Text/Text';

interface ITrainsSegmentDurationProps
    extends IWithQaAttributes,
        IWithClassName,
        IWithDeviceType {
    duration: number;
    isRangeArrivalTrain?: boolean;
}

const TrainsSegmentDuration: React.FC<ITrainsSegmentDurationProps> = props => {
    const {duration, isRangeArrivalTrain, deviceType} = props;
    const durationMoment = moment.duration(duration, 'seconds');
    const durationPrefix = isRangeArrivalTrain
        ? i18nBlock.durationDashFrom()
        : '';

    return (
        <Text
            className={props.className}
            size={deviceType.isMobile ? 's' : 'm'}
            weight={deviceType.isMobile ? 'normal' : 'medium'}
            color={deviceType.isMobile ? 'secondary' : 'primary'}
            tag="div"
            {...prepareQaAttributes(props)}
        >
            {`${durationPrefix}${humanizeDuration(durationMoment)}`}
        </Text>
    );
};

export default TrainsSegmentDuration;
