import React, {ReactNode} from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Flex from 'components/Flex/Flex';

import cx from './TrainsSegmentLayout.scss';

interface ITrainsSegmentLayoutProps extends IWithClassName, IWithQaAttributes {
    left?: ReactNode;
    center?: ReactNode;
    right?: ReactNode;

    leftClassName?: string;
    centerClassName?: string;
    rightClassName?: string;
}

const TrainsSegmentLayout: React.FC<ITrainsSegmentLayoutProps> = props => {
    const {
        className,
        left,
        center,
        right,
        leftClassName,
        rightClassName,
        centerClassName,
    } = props;

    return (
        <Flex className={cx('root', className)} {...prepareQaAttributes(props)}>
            <Flex className={cx('leftAndCenter')}>
                <Flex
                    className={cx('leftSide', leftClassName)}
                    justifyContent="space-between"
                    nowrap
                    inline
                    between={4}
                >
                    {left}
                </Flex>

                <Flex className={cx('centerSide', centerClassName)}>
                    {center}
                </Flex>
            </Flex>

            <Flex className={cx('rightSide', rightClassName)}>{right}</Flex>
        </Flex>
    );
};

export default TrainsSegmentLayout;
