import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';
import {ITrainsStation} from 'types/trains/common/station/ITrainsStation';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Box from 'components/Box/Box';
import Text from 'components/Text/Text';

import TrainsSegmentTime from '../TrainsSegmentTime/TrainsSegmentTime';

import cx from './TrainsSegmentPoint.scss';

interface ITrainsSegmentPointProps
    extends IWithClassName,
        IWithDeviceType,
        IWithQaAttributes {
    station: ITrainsStation;
    time: string;
    minTime?: string;
    maxTime?: string;
    isDateVisible?: boolean;
    isStationVisible?: boolean;
}

const TrainsSegmentPoint: React.FC<ITrainsSegmentPointProps> = props => {
    const {
        className,
        station,
        isStationVisible,
        time,
        minTime,
        maxTime,
        deviceType,
        isDateVisible,
    } = props;

    return (
        <Box className={className}>
            <TrainsSegmentTime
                time={time}
                minTime={minTime}
                maxTime={maxTime}
                timezone={station.timezone}
                isDateVisible={isDateVisible}
                deviceType={deviceType}
                {...prepareQaAttributes(props)}
            />

            {isStationVisible && (
                <Text
                    size="m"
                    weight="medium"
                    className={cx('station')}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'station',
                    })}
                >
                    {station.title}
                </Text>
            )}
        </Box>
    );
};

export default TrainsSegmentPoint;
