import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';
import {ITrainsStation} from 'types/trains/common/station/ITrainsStation';
import {ITrainsTrainRangeArrival} from 'types/trains/common/features/TTrainsFeature';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Box from 'components/Box/Box';

import TrainsSegmentPoint from '../TrainsSegmentPoint/TrainsSegmentPoint';

import cx from './TrainsSegmentPoints.scss';

interface ITrainsSegmentPointsProps
    extends IWithDeviceType,
        IWithClassName,
        IWithQaAttributes {
    stationFrom: ITrainsStation;
    stationTo: ITrainsStation;
    arrival: string;
    departure: string;
    trainRangeArrival?: ITrainsTrainRangeArrival;
}

const TrainsSegmentPoints: React.FC<ITrainsSegmentPointsProps> = props => {
    const {
        className,
        stationFrom,
        stationTo,
        arrival,
        departure,
        trainRangeArrival,
        deviceType,
    } = props;

    return (
        <Box className={cx('points', className)} inline between={4} nowrap>
            <TrainsSegmentPoint
                className={cx('point')}
                isStationVisible
                isDateVisible
                station={stationFrom}
                time={departure}
                deviceType={deviceType}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'departure',
                })}
            />
            <TrainsSegmentPoint
                className={cx('point')}
                station={stationTo}
                isStationVisible
                isDateVisible
                time={arrival}
                minTime={trainRangeArrival?.min}
                maxTime={trainRangeArrival?.max}
                deviceType={deviceType}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'arrival',
                })}
            />
        </Box>
    );
};

export default TrainsSegmentPoints;
