import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {ITrainsStation} from 'types/trains/common/station/ITrainsStation';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {CHAR_EM_DASH, CHAR_NBSP} from 'utilities/strings/charCodes';

import Text from 'components/Text/Text';

interface ITrainsSegmentStationsProps
    extends IWithClassName,
        IWithQaAttributes {
    stationFrom: ITrainsStation;
    stationTo: ITrainsStation;
}

const TrainsSegmentStations: React.FC<ITrainsSegmentStationsProps> = props => {
    const {className, stationFrom, stationTo} = props;

    return (
        <Text
            className={className}
            size="s"
            {...prepareQaAttributes({
                parent: props,
                current: 'stations',
            })}
        >
            {`${stationFrom.title}${CHAR_NBSP}${CHAR_EM_DASH} ${stationTo.title}`}
        </Text>
    );
};

export default TrainsSegmentStations;
