import React, {useCallback} from 'react';

import {ETrainsVariantUrlOwner} from 'types/trains/common/variant/ETrainsVariantUrlOwner';
import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';
import {ITrainsVariant} from 'types/trains/common/variant/ITrainsVariant';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {ITrainsMinTariffClass} from 'types/trains/common/tariffs/ITrainsMinTariffsClass';

import {trainsURLs} from 'projects/trains/lib/urls';
import {reachGoal} from 'utilities/metrika';

import Link from 'components/Link/Link';

interface ITrainsSegmentTariffLinkProps {
    variant: ITrainsVariant;
    context: ITrainsFilledSearchContext;
    tariff: ITrainsMinTariffClass;
}

const TrainsSegmentTariffLink: React.FC<ITrainsSegmentTariffLinkProps> =
    props => {
        const {variant, tariff, context, children} = props;
        const {orderUrl} = variant;

        const handleExternalLinkClick = useCallback(() => {
            reachGoal(ETrainsGoal.ORDER_UFS_LINK_CLICK);
        }, []);

        if (!orderUrl) {
            return null;
        }

        if (orderUrl.owner === ETrainsVariantUrlOwner.UFS) {
            return (
                <Link
                    theme="black"
                    url={orderUrl.url}
                    target="_blank"
                    rel="noopener noreferrer"
                    onClick={handleExternalLinkClick}
                >
                    {children}
                </Link>
            );
        }

        return (
            <Link
                theme="black"
                to={trainsURLs.getTrainsOrderUrlBySearchParams({
                    variant,
                    context,
                    tariff,
                })}
            >
                {children}
            </Link>
        );
    };

export default TrainsSegmentTariffLink;
