import {useMemo} from 'react';

import {TTrainsPlacesDetails} from 'types/trains/common/tariffs/TTrainsPlacesDetails';

import {getTariffPlaceDetailTitleByType} from './utilities/getTariffPlaceDetailTitleByType';
import {filterEmptyTariffPlaceDetailTypes} from './utilities/filterEmptyTariffPlaceDetailTypes';

import Flex from 'components/Flex/Flex';
import {TBoxSizes} from 'components/Box/Box';
import Text, {TTextColor, TTextSize} from 'components/Text/Text';

import cx from './TrainsSegmentTariffPlacesDetails.scss';

interface ITrainsSegmentTariffPlacesDetailsProps {
    placesDetails: TTrainsPlacesDetails;
    textColor?: TTextColor;
    textSize?: TTextSize;
    boxBetween?: TBoxSizes;
}

const TrainsSegmentTariffPlacesDetails: React.FC<ITrainsSegmentTariffPlacesDetailsProps> =
    props => {
        const {placesDetails, textColor, textSize, boxBetween} = props;
        const tariffPlaceDetailTypes = useMemo(() => {
            return filterEmptyTariffPlaceDetailTypes(placesDetails);
        }, [placesDetails]);

        return (
            <Flex flexDirection="column" between={boxBetween}>
                {tariffPlaceDetailTypes.map(placeType => {
                    const placeQuantity = placesDetails[placeType].quantity;

                    return (
                        <Flex
                            justifyContent="space-between"
                            className={cx('place')}
                            key={placeType}
                        >
                            <Text color={textColor} size={textSize}>
                                {getTariffPlaceDetailTitleByType(placeType)}
                            </Text>
                            <Text color={textColor} size={textSize}>
                                {placeQuantity}
                            </Text>
                        </Flex>
                    );
                })}
            </Flex>
        );
    };

export default TrainsSegmentTariffPlacesDetails;
