import _isEmpty from 'lodash/isEmpty';

import {SORTED_AND_SUPPORTED_PLACE_DETAIL_TYPES} from '../constants/placeDetailTypes';

import {
    ETrainsPlaceType,
    TTrainsPlacesDetails,
} from 'types/trains/common/tariffs/TTrainsPlacesDetails';

export const filterEmptyTariffPlaceDetailTypes = (
    placesDetails: TTrainsPlacesDetails,
): ETrainsPlaceType[] => {
    return SORTED_AND_SUPPORTED_PLACE_DETAIL_TYPES.filter(placeType =>
        Boolean(placesDetails[placeType]?.quantity),
    );
};

export const checkTariffWithNotEmptyPlacesDetails = (
    placesDetails?: TTrainsPlacesDetails,
): boolean => {
    if (!placesDetails || _isEmpty(placesDetails)) {
        return false;
    }

    return filterEmptyTariffPlaceDetailTypes(placesDetails).length > 0;
};
