import {ETrainsPlaceType} from 'types/trains/common/tariffs/TTrainsPlacesDetails';

import * as i18nBlock from 'i18n/trains-search-tariff-places-details';

export const getTariffPlaceDetailTitleByType = (
    type: ETrainsPlaceType,
): string => {
    switch (type) {
        case ETrainsPlaceType.LOWER: {
            return i18nBlock.lower();
        }

        case ETrainsPlaceType.LOWER_SLIDE: {
            return i18nBlock.lowerSide();
        }

        case ETrainsPlaceType.UPPER: {
            return i18nBlock.upper();
        }

        case ETrainsPlaceType.UPPER_SLIDE: {
            return i18nBlock.upperSide();
        }
    }
};
