import {FC, RefObject, useMemo} from 'react';

import EPopupDirection from 'components/Popup/types/EPopupDirection';
import {TTrainsPlacesDetails} from 'types/trains/common/tariffs/TTrainsPlacesDetails';

import {checkTariffWithNotEmptyPlacesDetails} from '../TrainsSegmentTariffPlacesDetails/utilities/filterEmptyTariffPlaceDetailTypes';

import Box from 'components/Box/Box';
import MessageBoxPopup from 'components/MessageBoxPopup/MessageBoxPopup';

import TrainsSegmentTariffPlacesDetails from '../TrainsSegmentTariffPlacesDetails/TrainsSegmentTariffPlacesDetails';

import cx from './TrainsSegmentTariffPlacesDetailsTooltip.scss';

interface ITrainsSegmentTariffPlacesDetailsTooltipProps {
    isVisible: boolean;
    triggerRef: RefObject<HTMLElement>;
    placesDetails: TTrainsPlacesDetails;
    scope?: HTMLElement;
}

const DIRECTION_POPUP = [EPopupDirection.BOTTOM, EPopupDirection.TOP];

const TrainsSegmentTariffPlacesDetailsTooltip: FC<ITrainsSegmentTariffPlacesDetailsTooltipProps> =
    props => {
        const {triggerRef, isVisible, placesDetails, scope} = props;
        const hasTariffWithNotEmptyPlacesDetails = useMemo(
            () => checkTariffWithNotEmptyPlacesDetails(placesDetails),
            [placesDetails],
        );

        const boundaryRef = useMemo<RefObject<HTMLElement> | undefined>(() => {
            if (!scope) {
                return undefined;
            }

            return {
                current: scope,
            };
        }, [scope]);

        if (!hasTariffWithNotEmptyPlacesDetails) {
            return null;
        }

        return (
            <MessageBoxPopup
                isVisible={isVisible}
                anchorRef={triggerRef}
                hasClose={false}
                direction={DIRECTION_POPUP}
                boundaryRef={boundaryRef}
            >
                <Box className={cx('content')} x="6" y="6">
                    <TrainsSegmentTariffPlacesDetails
                        placesDetails={placesDetails}
                        textColor="inverse"
                        textSize="s"
                    />
                </Box>
            </MessageBoxPopup>
        );
    };

export default TrainsSegmentTariffPlacesDetailsTooltip;
