import {useMemo, FC} from 'react';

import {ITrainsMinTariffClass} from 'types/trains/common/tariffs/ITrainsMinTariffsClass';

import {filterTariffsWithEmptyPlaceDetailTypes} from './utilities/filterTariffsWithEmptyPlaceDetailTypes';
import getTariffClass from 'projects/trains/lib/getTariffClass';

import Flex from 'components/Flex/Flex';
import TrainsSegmentTariffPlacesDetails from 'projects/trains/components/TrainsSearchVariants/components/TrainsSearchSegment/components/TrainsSegmentTariffPlacesDetails/TrainsSegmentTariffPlacesDetails';
import Text from 'components/Text/Text';

import cx from './TrainsSegmentTariffsPlacesDetails.scss';

interface ITrainsSegmentTariffsPlacesDetailsProps {
    tariffs: ITrainsMinTariffClass[];
}

const TrainsSegmentTariffsPlacesDetails: FC<ITrainsSegmentTariffsPlacesDetailsProps> =
    props => {
        const {tariffs} = props;
        const tariffsWithNotEmptyPlacesDetails = useMemo(() => {
            return filterTariffsWithEmptyPlaceDetailTypes(tariffs);
        }, [tariffs]);

        return (
            <Flex flexDirection="column" between={6}>
                {tariffsWithNotEmptyPlacesDetails.map(tariff => {
                    const {placesDetails} = tariff;

                    if (!placesDetails) {
                        return null;
                    }

                    return (
                        <Flex
                            key={tariff.type}
                            flexDirection="column"
                            between={1}
                        >
                            <Text
                                color="primary"
                                weight="bold"
                                size="m"
                                className={cx('tariffClass')}
                            >
                                {getTariffClass(tariff.type)}
                            </Text>
                            <TrainsSegmentTariffPlacesDetails
                                placesDetails={placesDetails}
                                textColor="primary"
                                textSize="m"
                                boxBetween={1}
                            />
                        </Flex>
                    );
                })}
            </Flex>
        );
    };

export default TrainsSegmentTariffsPlacesDetails;
