import {ITrainsMinTariffClass} from 'types/trains/common/tariffs/ITrainsMinTariffsClass';

import {checkTariffWithNotEmptyPlacesDetails} from 'projects/trains/components/TrainsSearchVariants/components/TrainsSearchSegment/components/TrainsSegmentTariffPlacesDetails/utilities/filterEmptyTariffPlaceDetailTypes';

export const filterTariffsWithEmptyPlaceDetailTypes = (
    tariffs: ITrainsMinTariffClass[],
): ITrainsMinTariffClass[] => {
    return tariffs.filter(tariff => {
        const {placesDetails} = tariff;

        return checkTariffWithNotEmptyPlacesDetails(placesDetails);
    });
};

export const checkTariffsWithNotEmptyPlacesDetails = (
    tariffs: ITrainsMinTariffClass[],
): boolean => {
    return filterTariffsWithEmptyPlaceDetailTypes(tariffs).length > 0;
};
