import {FC, useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';
import {ITrain} from 'types/trains/common/train/ITrain';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {ITrainsVariant} from 'types/trains/common/variant/ITrainsVariant';
import {TTrainsFeatures} from 'types/trains/common/features/TTrainsFeatures';
import {ITrainsMinTariffClass} from 'types/trains/common/tariffs/ITrainsMinTariffsClass';

import {getTrainNameByFeatures} from 'projects/trains/lib/genericSearch/train/getTrainNameByFeatures';

import Text from 'components/Text/Text';
import TriggerDetailsButton from 'components/TriggerDetailsButton/TriggerDetailsButton';
import TrainsSearchVariantAction from 'projects/trains/components/TrainsSearchVariants/components/TrainsSearchVariantAction/TrainsSearchVariantAction';

import TrainsSegmentTariffsPlacesDetails from '../TrainsSegmentTariffsPlacesDetails/TrainsSegmentTariffsPlacesDetails';

import cx from './TrainsSegmentTariffsPlacesDetailsBottomSheet.scss';

interface ITrainsSegmentTariffsPlacesDetailsBottomSheetProps
    extends IWithDeviceType,
        IWithClassName {
    train: ITrain;
    variant: ITrainsVariant;
    tariffs: ITrainsMinTariffClass[];
    context: ITrainsFilledSearchContext;
    features?: TTrainsFeatures;
    triggerClassName?: string;
    hasVariantAction?: boolean;
}

const TrainsSegmentTariffsPlacesDetailsBottomSheet: FC<ITrainsSegmentTariffsPlacesDetailsBottomSheetProps> =
    props => {
        const {
            className,
            tariffs,
            variant,
            context,
            features,
            train,
            deviceType,
            hasVariantAction,
        } = props;
        const trainTitle = useMemo(() => {
            const trainName = getTrainNameByFeatures({features});
            const trainNumber = train?.displayNumber;

            if (trainName || trainNumber) {
                return `${trainNumber ?? ''} ${trainName ?? ''}`;
            }

            return null;
        }, [train, features]);

        return (
            <TriggerDetailsButton className={cx(className, 'detailsButton')}>
                {trainTitle && (
                    <Text
                        className={cx('trainTitle')}
                        color="primary"
                        weight="bold"
                        size="xl"
                        tag="div"
                    >
                        {trainTitle}
                    </Text>
                )}
                <TrainsSegmentTariffsPlacesDetails tariffs={tariffs} />
                {hasVariantAction && (
                    <TrainsSearchVariantAction
                        className={cx('variantAction')}
                        variant={variant}
                        context={context}
                        deviceType={deviceType}
                    />
                )}
            </TriggerDetailsButton>
        );
    };

export default TrainsSegmentTariffsPlacesDetailsBottomSheet;
