import React from 'react';
import moment from 'moment-timezone';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import TrainsTime from 'projects/trains/components/TrainsTime/TrainsTime';

import TrainsSegmentTimeRange from '../TrainsSegmentTimeRange/TrainsSegmentTimeRange';

import cx from './TrainsSegmentTime.scss';

interface ITrainsSegmentTimeProps
    extends IWithClassName,
        IWithDeviceType,
        IWithQaAttributes {
    time: string;
    minTime?: string;
    maxTime?: string;
    timezone: string;
    isDateVisible?: boolean;
}

const TrainsSegmentTime: React.FC<ITrainsSegmentTimeProps> = props => {
    const {
        className,
        time,
        minTime,
        maxTime,
        timezone,
        deviceType,
        isDateVisible,
    } = props;
    const timeMoment = moment.tz(time, timezone);
    const isRange = minTime && maxTime && minTime !== maxTime;

    if (isRange) {
        return (
            <TrainsSegmentTimeRange
                className={className}
                minTime={minTime}
                maxTime={maxTime}
                timezone={timezone}
                isDateVisible={isDateVisible}
                deviceType={deviceType}
            />
        );
    }

    return (
        <TrainsTime
            className={cx('time', className, deviceMods('time', deviceType))}
            dateClassName={cx('date', deviceMods('date', deviceType))}
            timeMoment={timeMoment}
            canShowDate={isDateVisible}
            deviceType={deviceType}
            {...prepareQaAttributes(props)}
        />
    );
};

export default TrainsSegmentTime;
