import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';
import {ITrainsStation} from 'types/trains/common/station/ITrainsStation';
import {ITrainsTrainRangeArrival} from 'types/trains/common/features/TTrainsFeature';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Separator from 'components/Separator/Separator';
import Flex from 'components/Flex/Flex';

import TrainsSegmentTime from '../TrainsSegmentTime/TrainsSegmentTime';
import TrainsSegmentDuration from '../TrainsSegmentDuration/TrainsSegmentDuration';

import cx from './TrainsSegmentTimings.scss';

interface ITrainsSegmentTimingsProps
    extends IWithDeviceType,
        IWithClassName,
        IWithQaAttributes {
    stationFrom: ITrainsStation;
    stationTo: ITrainsStation;
    arrival: string;
    departure: string;
    duration: number;
    trainRangeArrival?: ITrainsTrainRangeArrival;
}

const TrainsSegmentTimings: React.FC<ITrainsSegmentTimingsProps> = props => {
    const {
        className,
        deviceType,
        departure,
        arrival,
        stationFrom,
        stationTo,
        duration,
        trainRangeArrival,
    } = props;

    const isRangeArrivalTrain = Boolean(trainRangeArrival);

    return (
        <Flex alignItems="flex-end" className={cx(className)}>
            <TrainsSegmentTime
                className={cx('time', 'time_isDeparture')}
                isDateVisible
                time={departure}
                timezone={stationFrom.timezone}
                deviceType={deviceType}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'departure',
                })}
            />
            <div className={cx('durationBlock')}>
                <Separator className={cx('separator')} />
                <TrainsSegmentDuration
                    className={cx('duration')}
                    duration={duration}
                    deviceType={deviceType}
                    isRangeArrivalTrain={isRangeArrivalTrain}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'duration',
                    })}
                />
            </div>
            <TrainsSegmentTime
                className={cx('time', 'time_isArrival')}
                isDateVisible
                time={arrival}
                timezone={stationTo.timezone}
                minTime={trainRangeArrival?.min}
                maxTime={trainRangeArrival?.max}
                deviceType={deviceType}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'arrival',
                })}
            />
        </Flex>
    );
};

export default TrainsSegmentTimings;
