import React from 'react';

import {ISearchSegmentBadge} from 'components/SearchSegmentBadges/types/ISearchSegmentBadge';

import SearchSegmentBadges from 'components/SearchSegmentBadges/SearchSegmentBadges';

interface ITrainsSearchVariantBadgesProps {
    variantBadges?: ISearchSegmentBadge[];
}

const TrainsSearchVariantBadges: React.FC<ITrainsSearchVariantBadgesProps> =
    props => {
        const {variantBadges} = props;

        if (!variantBadges?.length) {
            return null;
        }

        return <SearchSegmentBadges items={variantBadges} />;
    };

export default TrainsSearchVariantBadges;
