import {ISearchSegmentBadge} from 'components/SearchSegmentBadges/types/ISearchSegmentBadge';
import {ITrainsVariant} from 'types/trains/common/variant/ITrainsVariant';
import {ITrainsSearchBadgesInfo} from 'types/trains/search/badgesInfo/ITrainsSearchBadgesInfo';

import {IDevice} from 'reducers/common/commonReducerTypes';

import * as i18nBlock from 'i18n/trains-badges';

import {ELabelThemeType, TLabelSizeType} from 'components/Label/Label';

export const getSearchVariantBadges = ({
    variant,
    badgesInfo,
    deviceType,
}: {
    variant: ITrainsVariant;
    badgesInfo: ITrainsSearchBadgesInfo;
    deviceType: IDevice;
}): ISearchSegmentBadge[] => {
    const resultBadges = [];
    const {id} = variant;
    const {
        fastestVariantsInfo,
        cheapestVariantsInfo,
        withoutERegistrationVariantsInfo,
        nonRefundableTariffVariantsInfo,
    } = badgesInfo;
    const hasFastestBadge =
        fastestVariantsInfo.canUseInfo &&
        fastestVariantsInfo.variantIds.includes(id);
    const hasCheapestBadge =
        cheapestVariantsInfo.canUseInfo &&
        cheapestVariantsInfo.variantIds.includes(id);
    const hasWithoutERegistrationBadge =
        withoutERegistrationVariantsInfo.variantIds.includes(id);
    const hasNonRefundableTariffBadge =
        nonRefundableTariffVariantsInfo.variantIds.includes(id);
    const badgeSize: TLabelSizeType = deviceType.isDesktop ? 'm' : 's';

    if (hasFastestBadge) {
        resultBadges.push({
            text: i18nBlock.fastest(),
            theme: ELabelThemeType.NORMAL,
            size: badgeSize,
        });
    }

    if (hasCheapestBadge) {
        resultBadges.push({
            text: i18nBlock.cheapest(),
            theme: ELabelThemeType.PRIMARY,
            size: badgeSize,
        });
    }

    if (hasWithoutERegistrationBadge) {
        resultBadges.push({
            text: i18nBlock.withoutDashEDashRegistration(),
            theme: ELabelThemeType.ATTENTION,
            size: badgeSize,
        });
    }

    if (hasNonRefundableTariffBadge) {
        resultBadges.push({
            text: i18nBlock.nonRefundableTariffDiscount(),
            theme: ELabelThemeType.ATTENTION,
            size: badgeSize,
        });
    }

    return resultBadges;
};
