import {ETrainsBrokenClassesCode} from 'types/trains/common/tariffs/ETrainsBrokenClassesCode';
import {ITrainsSegment} from 'types/trains/common/segment/ITrainsSegment';

export const getVariantBrokenClassesCode = (
    segments: ITrainsSegment[],
): ETrainsBrokenClassesCode | undefined => {
    return segments.reduce<ETrainsBrokenClassesCode | undefined>(
        (variantBrokenClassesCode, segment) => {
            const currentBrokenClassesCode =
                segment?.tariffs?.brokenClassesCode;

            if (!variantBrokenClassesCode) {
                return currentBrokenClassesCode;
            }

            if (!currentBrokenClassesCode) {
                return variantBrokenClassesCode;
            }

            if (
                variantBrokenClassesCode === ETrainsBrokenClassesCode.SOLD_OUT
            ) {
                return variantBrokenClassesCode;
            }

            return currentBrokenClassesCode;
        },
        undefined,
    );
};
