import React, {memo} from 'react';

import {EDirection} from 'types/common/EDirection';
import {ITrainsVariant} from 'types/trains/common/variant/ITrainsVariant';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {EQueryingStatus} from 'types/trains/search/searchInfo/ITrainsSearchInfo';
import {IWithDeviceType} from 'types/withDeviceType';
import {ITrainsSearchBadgesInfo} from 'types/trains/search/badgesInfo/ITrainsSearchBadgesInfo';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import {useTrainsSearchVariantBadges} from 'projects/trains/pages/TrainsSearchPage/hooks/useTrainsSearchVariantBadges';

import TrainsDesktopSearchVariantWithTransfer, {
    ITrainsDesktopSearchVariantWithTransferProps,
} from './TrainsDesktopSearchVariantWithTransfer/TrainsDesktopSearchVariantWithTransfer';
import TrainsMobileSearchVariantWithTransfer, {
    ITrainsMobileSearchVariantWithTransferProps,
} from './TrainsMobileSearchVariantWithTransfer/TrainsMobileSearchVariantWithTransfer';

export interface ITrainsSearchVariantWithTransferProps
    extends IWithDeviceType,
        IWithQaAttributes {
    variant: ITrainsVariant;
    context: ITrainsFilledSearchContext;
    searchStatus: EQueryingStatus;
    badgesInfo: ITrainsSearchBadgesInfo;
    direction: EDirection;
}

const TrainsSearchVariantWithTransfer: React.FC<ITrainsSearchVariantWithTransferProps> =
    props => {
        const {
            deviceType,
            variant,
            context,
            searchStatus,
            badgesInfo,
            direction,
        } = props;
        const variantBadges = useTrainsSearchVariantBadges({
            variant,
            deviceType,
            badgesInfo,
        });
        const variantWithTransferProps: ITrainsDesktopSearchVariantWithTransferProps &
            ITrainsMobileSearchVariantWithTransferProps = {
            variant,
            context,
            direction,
            deviceType,
            searchStatus,
            variantBadges,
            ...prepareQaAttributes(props),
        };

        if (deviceType.isDesktop) {
            return (
                <TrainsDesktopSearchVariantWithTransfer
                    {...variantWithTransferProps}
                />
            );
        }

        return (
            <TrainsMobileSearchVariantWithTransfer
                {...variantWithTransferProps}
            />
        );
    };

export default memo(TrainsSearchVariantWithTransfer);
