import React from 'react';

import {EDirection} from 'types/common/EDirection';
import {ITrainsVariant} from 'types/trains/common/variant/ITrainsVariant';
import {ITrainsFilledSearchContext} from 'reducers/trains/context/types';
import {EQueryingStatus} from 'types/trains/search/searchInfo/ITrainsSearchInfo';
import {IWithDeviceType} from 'types/withDeviceType';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Box from 'components/Box/Box';
import TrainsSearchSegment from 'projects/trains/components/TrainsSearchVariants/components/TrainsSearchSegment/TrainsSearchSegment';

import TrainsSearchVariantTransferSeparator from '../TrainsSearchVariantTransferSeparator/TrainsSearchVariantTransferSeparator';

interface ITrainsSearchVariantTransferSegmentsProps
    extends IWithDeviceType,
        IWithQaAttributes {
    variant: ITrainsVariant;
    direction: EDirection;
    context: ITrainsFilledSearchContext;
    searchStatus: EQueryingStatus;
}

const TrainsSearchVariantTransferSegments: React.FC<ITrainsSearchVariantTransferSegmentsProps> =
    props => {
        const {variant, context, searchStatus, deviceType, direction} = props;
        const {forward} = variant;

        return (
            <>
                {forward.map((segment, index) => (
                    <React.Fragment key={segment.id}>
                        <TrainsSearchSegment
                            segment={segment}
                            variant={variant}
                            context={context}
                            isTransferSegment
                            direction={direction}
                            searchStatus={searchStatus}
                            canVisibleSegmentAction={false}
                            {...prepareQaAttributes({
                                key: index,
                                parent: props,
                                current: 'segment',
                            })}
                        />
                        {index < forward.length - 1 && (
                            <Box y={deviceType.isDesktop ? 5 : 3}>
                                <TrainsSearchVariantTransferSeparator
                                    currentSegment={segment}
                                    nextSegment={forward[index + 1]}
                                    deviceType={deviceType}
                                />
                            </Box>
                        )}
                    </React.Fragment>
                ))}
            </>
        );
    };

export default TrainsSearchVariantTransferSegments;
